/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.graphics.LegacyAnimator;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarListener;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarUI;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public abstract class DarkRoundedScrollBarUI
extends DarkScrollBarUI {
    protected boolean hideScrollBar = false;
    private int minimumSize;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.minimumSize = UIManager.getInt("ScrollBar.minimumWidth");
    }

    protected abstract int getTrackFadeOutDelay();

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle bounds) {
    }

    @Override
    protected void paintMaxiThumb(Graphics2D g, Rectangle rect) {
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        g.setComposite(COMPOSITE.derive(this.thumbAlpha));
        boolean horizontal = this.scrollbar.getOrientation() == 0;
        int ins = 2;
        RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float();
        int width = rect.width - 2 * ins;
        int height = rect.height - 2 * ins;
        int x = rect.x + ins;
        int y = rect.y + ins;
        if (this.hideScrollBar) {
            float animationState = this.scrollBarListener.getTrackState();
            if (horizontal) {
                int newHeight = Math.round((float)this.minimumSize + (float)(height - this.minimumSize) * animationState);
                y += height - newHeight;
                height = newHeight;
            } else {
                int newWidth = Math.round((float)this.minimumSize + (float)(width - this.minimumSize) * animationState);
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    x += width - newWidth;
                }
                width = newWidth;
            }
        }
        int arc = horizontal ? height : width;
        ((RoundRectangle2D)roundRect).setRoundRect(x, y, width, height, arc, arc);
        if (!((RectangularShape)roundRect).isEmpty()) {
            g.setColor(this.getThumbColor());
            g.fill(roundRect);
            g.setColor(this.getThumbBorderColor());
            g.draw(roundRect);
        }
        context.restore();
    }

    protected DarkScrollBarListener<DarkRoundedScrollBarUI> createScrollBarListener() {
        return new RoundedScrollBarListener(this.scrollbar, this);
    }

    private static class RoundedScrollBarListener
    extends DarkScrollBarListener<DarkRoundedScrollBarUI> {
        private final Timer hideTimer;

        public RoundedScrollBarListener(JScrollBar scrollbar, DarkRoundedScrollBarUI ui) {
            super(scrollbar, ui);
            int hideDelay = this.getTrackFadeOutDelay();
            this.hideTimer = new Timer(hideDelay, e -> {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, scrollbar);
                this.mouseOverTrack = scrollbar.contains(p);
                this.resetTrackAnimator();
            });
            this.hideTimer.setRepeats(false);
        }

        @Override
        protected boolean animateTrackOnScroll(JScrollBar scrollbar) {
            return ((DarkRoundedScrollBarUI)this.ui).hideScrollBar;
        }

        @Override
        protected LegacyAnimator createTrackFadeinAnimator() {
            return ((DarkRoundedScrollBarUI)this.ui).hideScrollBar ? super.createTrackFadeinAnimator() : null;
        }

        @Override
        protected LegacyAnimator createTrackFadeoutAnimator() {
            return ((DarkRoundedScrollBarUI)this.ui).hideScrollBar ? super.createTrackFadeoutAnimator() : null;
        }

        @Override
        protected int getTrackFadeOutDelay() {
            return ((DarkRoundedScrollBarUI)this.ui).getTrackFadeOutDelay();
        }

        @Override
        protected void runOnScrollTrackAnimation() {
            super.runOnScrollTrackAnimation();
            this.hideTimer.stop();
            this.hideTimer.start();
        }

        @Override
        protected void resetTrackAnimator() {
            this.hideTimer.stop();
            super.resetTrackAnimator();
        }
    }
}

