/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class WidgetJsonRegistry {
    private static final Map<String, WidgetFactory> REGISTRY = new HashMap<String, WidgetFactory>();

    public static void init() {
        WidgetJsonRegistry.registerWidget("text", TextWidget::new);
        WidgetJsonRegistry.registerWidget("image", DrawableWidget::new);
        WidgetJsonRegistry.registerWidget("cycle_button", CycleButtonWidget::new);
        WidgetJsonRegistry.registerWidget("button", ButtonWidget::new);
        WidgetJsonRegistry.registerWidgetSpecial("player_inventory", SlotGroup::playerInventoryGroup);
        IDrawable.JSON_DRAWABLE_MAP.put("text", Text::ofJson);
        IDrawable.JSON_DRAWABLE_MAP.put("image", UITexture::ofJson);
    }

    public static void registerWidgetSpecial(String id, WidgetFactory factory) {
        ModularUI.logger.info("Register type {}", new Object[]{id});
        REGISTRY.put(id, factory);
    }

    public static void registerWidget(String id, Supplier<Widget> factory) {
        ModularUI.logger.info("Register type {}", new Object[]{id});
        REGISTRY.put(id, player -> (Widget)factory.get());
    }

    @Nullable
    public static WidgetFactory getFactory(String id) {
        return REGISTRY.get(id);
    }

    public static interface WidgetFactory {
        public Widget create(EntityPlayer var1);
    }
}

