/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import codechicken.nei.ItemPanels;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.animation.Animator;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.integration.nei.NEIDragAndDropHandler;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.Interpolations;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.neverenoughanimations.NEAConfig;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularPanel
extends ParentWidget<ModularPanel>
implements IViewport {
    private static final int tapTime = 200;
    @NotNull
    private final String name;
    private ModularScreen screen;
    private IPanelHandler panelHandler;
    private State state = State.IDLE;
    private boolean cantDisposeNow = false;
    private final ObjectList<LocatedWidget> hovering = ObjectList.create();
    private final Input keyboard = new Input();
    private final Input mouse = new Input();
    private final List<IPanelHandler> clientSubPanels = new ArrayList<IPanelHandler>();
    private boolean invisible = false;
    private Animator animator;

    public static ModularPanel defaultPanel(@NotNull String name) {
        return ModularPanel.defaultPanel(name, 176, 166);
    }

    public static ModularPanel defaultPanel(@NotNull String name, int width, int height) {
        return (ModularPanel)new ModularPanel(name).size(width, height);
    }

    public ModularPanel(@NotNull String name) {
        this.name = Objects.requireNonNull(name, "A panels name must not be null and should be unique!");
        this.center();
    }

    @Override
    @NotNull
    public ModularPanel getPanel() {
        return this;
    }

    @Override
    public Area getParentArea() {
        return this.getScreen().getScreenArea();
    }

    @Override
    public void onInit() {
        this.getScreen().registerFrameUpdateListener(this, this::findHoveredWidgets, false);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        return syncHandler instanceof IPanelHandler;
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public void closeIfOpen() {
        if (!this.isOpen()) {
            return;
        }
        this.closeSubPanels();
        if (this.isMainPanel()) {
            Platform.getClientPlayer().func_71053_j();
            return;
        }
        if (!this.shouldAnimate()) {
            this.screen.getPanelManager().closePanel(this);
            return;
        }
        if (!this.isOpening() && !this.isClosing()) {
            if (this.isMainPanel()) {
                for (ModularPanel panel : this.getScreen().getPanelManager().getOpenPanels()) {
                    if (panel.isMainPanel()) continue;
                    panel.closeIfOpen();
                }
            }
            this.getAnimator().onFinish(() -> this.screen.getPanelManager().closePanel(this));
            this.getAnimator().reset(true);
            this.getAnimator().animate(true);
        }
    }

    protected void closeSubPanels() {
        if (this.panelHandler != null) {
            this.panelHandler.closeSubPanels();
        }
    }

    public void animateClose() {
        this.closeIfOpen();
    }

    void setPanelHandler(IPanelHandler panelHandler) {
        this.panelHandler = panelHandler;
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public WidgetTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getPanelTheme();
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        if (this.getScale() != 1.0f) {
            float x = (float)this.getArea().w() / 2.0f;
            float y = (float)this.getArea().h() / 2.0f;
            stack.translate(x, y);
            stack.scale(this.getScale(), this.getScale());
            stack.translate(-x, -y);
        }
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    @Override
    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.isInside(stack, x, y)) {
            widgets.add(this, stack.peek());
        }
    }

    private void findHoveredWidgets() {
        this.hovering.clear();
        this.hovering.trim();
        if (!this.isEnabled()) {
            return;
        }
        HoveredWidgetList widgetList = new HoveredWidgetList(this.hovering);
        this.getContext().reset();
        GuiViewportStack stack = new GuiViewportStack();
        stack.pushViewport(null, this.getScreen().getScreenArea());
        stack.pushViewport(this, this.getArea());
        this.transform(stack);
        this.getSelfAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        this.transformChildren(stack);
        this.getWidgetsAt(stack, widgetList, this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
        stack.popViewport(this);
        stack.popViewport(null);
    }

    @Override
    public boolean canHover() {
        return !this.invisible && super.canHover();
    }

    @MustBeInvokedByOverriders
    public void onOpen(ModularScreen screen) {
        this.screen = screen;
        this.getArea().z(1);
        this.initialise(this);
        WidgetTree.onUpdate(this);
        if (!this.isMainPanel() && this.shouldAnimate()) {
            this.getAnimator().onFinish(() -> {});
            this.getAnimator().reset();
            this.getAnimator().animate();
        }
        this.state = State.OPEN;
    }

    void reopen() {
        if (this.state != State.CLOSED) {
            throw new IllegalStateException();
        }
        this.state = State.OPEN;
    }

    @MustBeInvokedByOverriders
    public void onClose() {
        if (!this.getScreen().isOverlay()) {
            this.getContext().getNEISettings().removeNEIExclusionArea(this);
        }
        this.state = State.CLOSED;
        if (this.panelHandler != null) {
            this.panelHandler.closePanelInternal();
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void dispose() {
        if (this.state == State.DISPOSED) {
            return;
        }
        if (this.state != State.CLOSED && this.state != State.WAIT_DISPOSING) {
            throw new IllegalStateException("Panel must be closed before disposing!");
        }
        if (this.cantDisposeNow) {
            this.state = State.WAIT_DISPOSING;
            return;
        }
        super.dispose();
        this.screen = null;
        this.state = State.DISPOSED;
    }

    public final <T> T doSafe(Supplier<T> runnable) {
        if (this.state == State.DISPOSED) {
            return null;
        }
        return (T)this.getScreen().getPanelManager().doSafe(() -> {
            this.cantDisposeNow = true;
            Object t = runnable.get();
            this.cantDisposeNow = false;
            if (this.state == State.WAIT_DISPOSING) {
                this.state = State.CLOSED;
                this.dispose();
            }
            return t;
        });
    }

    public final boolean doSafeBool(BooleanSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsBoolean));
    }

    public final int doSafeInt(IntSupplier runnable) {
        return Objects.requireNonNull(this.doSafe(runnable::getAsInt));
    }

    public boolean onMousePressed(int mouseButton) {
        return this.doSafeBool(() -> {
            boolean result;
            LocatedWidget pressed;
            block11: {
                block10: {
                    pressed = LocatedWidget.EMPTY;
                    result = false;
                    if (!this.hovering.isEmpty()) break block10;
                    if (!this.closeOnOutOfBoundsClick()) break block11;
                    this.animateClose();
                    result = true;
                    break block11;
                }
                if (this.checkNEIGhostIngredient(mouseButton)) {
                    return true;
                }
                ObjectListIterator objectListIterator = this.hovering.iterator();
                while (objectListIterator.hasNext()) {
                    LocatedWidget widget = (LocatedWidget)objectListIterator.next();
                    widget.applyMatrix(this.getContext());
                    Object patt10999$temp = widget.getElement();
                    if (patt10999$temp instanceof Interactable) {
                        Interactable interactable = (Interactable)patt10999$temp;
                        Interactable.Result interactResult = interactable.onMousePressed(mouseButton);
                        if (interactResult.accepts) {
                            this.mouse.addAcceptedInteractable(interactable);
                            pressed = widget;
                        } else if (interactResult.stops) {
                            pressed = LocatedWidget.EMPTY;
                        }
                        if (interactResult.stops) {
                            result = true;
                            widget.unapplyMatrix(this.getContext());
                            break;
                        }
                    }
                    if (this.getContext().onHoveredClick(mouseButton, widget)) {
                        pressed = LocatedWidget.EMPTY;
                        result = true;
                        widget.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget.unapplyMatrix(this.getContext());
                    if (((IWidget)widget.getElement()).canClickThrough()) continue;
                    result = true;
                    pressed = widget;
                    break;
                }
            }
            if (result && pressed.getElement() instanceof IFocusedWidget) {
                this.getContext().focus(pressed);
            } else {
                this.getContext().removeFocus();
            }
            this.mouse.pressed(pressed, mouseButton);
            return result;
        });
    }

    private boolean checkNEIGhostIngredient(int mouseButton) {
        ItemStack dndTarget;
        if (ModularUI.Mods.NEI.isLoaded() && (dndTarget = this.getNEIDragAndDropTarget()) != null) {
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget = (LocatedWidget)objectListIterator.next();
                Object t = widget.getElement();
                if (!(t instanceof NEIDragAndDropHandler)) continue;
                NEIDragAndDropHandler dndHandler = (NEIDragAndDropHandler)t;
                if (dndHandler.handleDragAndDrop(dndTarget, mouseButton)) {
                    this.stopNEIGhostDrag();
                    this.mouse.pressed(widget, mouseButton);
                    this.mouse.doRelease = false;
                    this.getContext().removeFocus();
                    return true;
                }
                if (!(widget.getElement() instanceof Interactable) && ((IWidget)widget.getElement()).canClickThrough()) continue;
                break;
            }
            this.stopNEIGhostDrag();
            this.mouse.pressed(LocatedWidget.EMPTY, mouseButton);
            this.mouse.doRelease = false;
            this.getContext().removeFocus();
            return true;
        }
        return false;
    }

    public boolean onMouseRelease(int mouseButton) {
        return this.isEnabled() && this.doSafeBool(() -> {
            Interactable interactable;
            LocatedWidget widget2;
            if (!this.mouse.doRelease) {
                this.mouse.reset();
                return false;
            }
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseRelease(mouseButton), false).booleanValue()) {
                return true;
            }
            boolean lastPressedIsHovered = false;
            boolean tryTap = this.mouse.tryTap(mouseButton);
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                widget2 = (LocatedWidget)objectListIterator.next();
                if (!this.mouse.isWidget(widget2)) continue;
                Object patt15539$temp = widget2.getElement();
                if (patt15539$temp instanceof Interactable && this.onMouseRelease(mouseButton, tryTap, widget2, interactable = (Interactable)patt15539$temp)) {
                    return true;
                }
                lastPressedIsHovered = true;
                break;
            }
            objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                Object patt16005$temp;
                widget2 = (LocatedWidget)objectListIterator.next();
                if (this.mouse.isWidget(widget2) || !((patt16005$temp = widget2.getElement()) instanceof Interactable) || !this.onMouseRelease(mouseButton, tryTap, widget2, interactable = (Interactable)patt16005$temp)) continue;
                return true;
            }
            if (lastPressedIsHovered) {
                this.mouse.reset();
                return true;
            }
            this.mouse.reset();
            return false;
        });
    }

    private boolean onMouseRelease(int mouseButton, boolean tryTap, LocatedWidget widget, Interactable interactable) {
        boolean stop = false;
        widget.applyMatrix(this.getContext());
        if (tryTap && this.mouse.acceptedInteractions.remove(interactable)) {
            Interactable.Result tabResult = interactable.onMouseTapped(mouseButton);
            if (tabResult.stops) {
                stop = true;
            }
        }
        if (interactable.onMouseRelease(mouseButton)) {
            stop = true;
        }
        widget.unapplyMatrix(this.getContext());
        if (stop) {
            this.mouse.reset();
            return true;
        }
        return false;
    }

    private ItemStack getNEIDragAndDropTarget() {
        if (this.getContext().getScreen().isOverlay() || !this.getContext().getNEISettings().isNEIEnabled(this.screen)) {
            return null;
        }
        if (ItemPanels.itemPanel.draggedStack != null) {
            return ItemPanels.itemPanel.draggedStack;
        }
        if (ItemPanels.bookmarkPanel.draggedStack != null) {
            return ItemPanels.bookmarkPanel.draggedStack;
        }
        return null;
    }

    private void stopNEIGhostDrag() {
        if (ItemPanels.itemPanel.draggedStack != null && ItemPanels.itemPanel.draggedStack.field_77994_a == 0) {
            ItemPanels.itemPanel.draggedStack = null;
        }
        if (ItemPanels.bookmarkPanel.draggedStack != null && ItemPanels.bookmarkPanel.draggedStack.field_77994_a == 0) {
            ItemPanels.bookmarkPanel.draggedStack = null;
        }
    }

    @ApiStatus.OverrideOnly
    public boolean onKeyPressed(char typedChar, int keyCode) {
        return this.doSafeBool(() -> {
            switch (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyPressed(typedChar, keyCode), Interactable.Result.IGNORE)) {
                case STOP: {
                    this.keyboard.pressed(LocatedWidget.EMPTY, keyCode);
                    return true;
                }
                case SUCCESS: {
                    this.keyboard.pressed(this.getContext().getFocusedWidget(), keyCode);
                    return true;
                }
            }
            LocatedWidget pressed = null;
            boolean result = false;
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt18985$temp = widget2.getElement();
                if (patt18985$temp instanceof Interactable) {
                    Interactable interactable = (Interactable)patt18985$temp;
                    widget2.applyMatrix(this.getContext());
                    Interactable.Result interactResult = interactable.onKeyPressed(typedChar, keyCode);
                    if (interactResult.accepts) {
                        this.keyboard.addAcceptedInteractable(interactable);
                        pressed = widget2;
                    } else if (interactResult.stops) {
                        pressed = null;
                    }
                    if (interactResult.stops) {
                        result = true;
                        widget2.unapplyMatrix(this.getContext());
                        break;
                    }
                    widget2.unapplyMatrix(this.getContext());
                }
                if (((IWidget)widget2.getElement()).canClickThrough()) continue;
                break;
            }
            this.keyboard.pressed(pressed, keyCode);
            return result;
        });
    }

    public boolean onKeyRelease(char typedChar, int keyCode) {
        return this.doSafeBool(() -> {
            Interactable interactable;
            LocatedWidget widget2;
            if (!this.keyboard.doRelease) {
                this.keyboard.reset();
                return false;
            }
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onKeyRelease(typedChar, keyCode), false).booleanValue()) {
                return true;
            }
            boolean lastPressedIsHovered = false;
            boolean tryTap = this.keyboard.tryTap(keyCode);
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                widget2 = (LocatedWidget)objectListIterator.next();
                if (!this.keyboard.isWidget(widget2)) continue;
                Object patt20640$temp = widget2.getElement();
                if (patt20640$temp instanceof Interactable && this.onKeyRelease(typedChar, keyCode, tryTap, widget2, interactable = (Interactable)patt20640$temp)) {
                    return true;
                }
                lastPressedIsHovered = true;
                break;
            }
            objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                Object patt21114$temp;
                widget2 = (LocatedWidget)objectListIterator.next();
                if (this.keyboard.isWidget(widget2) || !((patt21114$temp = widget2.getElement()) instanceof Interactable) || !this.onKeyRelease(typedChar, keyCode, tryTap, widget2, interactable = (Interactable)patt21114$temp)) continue;
                return true;
            }
            if (lastPressedIsHovered) {
                this.keyboard.reset();
                return true;
            }
            this.keyboard.reset();
            return false;
        });
    }

    private boolean onKeyRelease(char typedChar, int keyCode, boolean tryTap, LocatedWidget widget, Interactable interactable) {
        boolean stop = false;
        widget.applyMatrix(this.getContext());
        if (tryTap && this.mouse.acceptedInteractions.remove(interactable)) {
            Interactable.Result tabResult = interactable.onKeyTapped(typedChar, keyCode);
            if (tabResult.stops) {
                stop = true;
            }
        }
        if (interactable.onKeyRelease(typedChar, keyCode)) {
            stop = true;
        }
        widget.unapplyMatrix(this.getContext());
        if (stop) {
            this.mouse.reset();
            return true;
        }
        return false;
    }

    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        return this.doSafeBool(() -> {
            if (this.interactFocused(widget -> ((Interactable)((Object)widget)).onMouseScroll(scrollDirection, amount), false).booleanValue()) {
                return true;
            }
            if (this.hovering.isEmpty()) {
                return false;
            }
            ObjectListIterator objectListIterator = this.hovering.iterator();
            while (objectListIterator.hasNext()) {
                LocatedWidget widget2 = (LocatedWidget)objectListIterator.next();
                Object patt22885$temp = widget2.getElement();
                if (!(patt22885$temp instanceof Interactable)) continue;
                Interactable interactable = (Interactable)patt22885$temp;
                widget2.applyMatrix(this.getContext());
                boolean result = interactable.onMouseScroll(scrollDirection, amount);
                widget2.unapplyMatrix(this.getContext());
                if (!result) continue;
                return true;
            }
            return false;
        });
    }

    public boolean onMouseDrag(int mouseButton, long timeSinceClick) {
        return this.doSafeBool(() -> {
            Object patt23557$temp;
            if (this.mouse.held && mouseButton == this.mouse.lastButton && this.mouse.lastPressed != null && (patt23557$temp = this.mouse.lastPressed.getElement()) instanceof Interactable) {
                Interactable interactable = (Interactable)patt23557$temp;
                this.mouse.lastPressed.applyMatrix(this.getContext());
                interactable.onMouseDrag(mouseButton, timeSinceClick);
                this.mouse.lastPressed.unapplyMatrix(this.getContext());
                return true;
            }
            return false;
        });
    }

    private <T, W extends IWidget & IFocusedWidget> T interactFocused(Function<W, T> function, T defaultValue) {
        LocatedWidget focused = this.getContext().getFocusedWidget();
        T result = defaultValue;
        Object t = focused.getElement();
        if (t instanceof Interactable) {
            Interactable interactable = (Interactable)t;
            focused.applyMatrix(this.getContext());
            result = function.apply((IWidget)((Object)interactable));
            focused.unapplyMatrix(this.getContext());
        }
        return result;
    }

    public boolean isDraggable() {
        return this.getScreen().getMainPanel() != this;
    }

    public boolean disablePanelsBelow() {
        return false;
    }

    public boolean closeOnOutOfBoundsClick() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public ModularScreen getScreen() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.screen;
    }

    @NotNull
    public ObjectList<LocatedWidget> getHovering() {
        return this.hovering;
    }

    @Nullable
    public IWidget getTopHovering() {
        LocatedWidget lw = this.getTopHoveringLocated(false);
        return lw == null ? null : (IWidget)lw.getElement();
    }

    @Nullable
    public LocatedWidget getTopHoveringLocated(boolean debug) {
        int i = 0;
        while (i < this.hovering.size()) {
            LocatedWidget widget = (LocatedWidget)this.hovering.get(i);
            if (!((IWidget)widget.getElement()).isValid()) {
                this.hovering.remove(i);
                continue;
            }
            if (debug || ((IWidget)widget.getElement()).canHover()) {
                return widget;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getDefaultHeight() {
        return 166;
    }

    @Override
    public int getDefaultWidth() {
        return 176;
    }

    final void setPanelGuiContext(@NotNull ModularGuiContext context) {
        this.setContext(context);
        if (!context.getScreen().isOverlay()) {
            context.getNEISettings().addNEIExclusionArea(this);
        }
    }

    public boolean isOpening() {
        return this.animator != null && this.animator.isAnimatingForward();
    }

    public boolean isClosing() {
        return this.animator != null && this.animator.isAnimatingReverse();
    }

    public float getScale() {
        if (!ModularUI.Mods.NEA.isLoaded() || NEAConfig.openingAnimationTime == 0) {
            return 1.0f;
        }
        return Interpolations.lerp(NEAConfig.openingStartScale, 1.0f, this.getAnimator().getValue());
    }

    public float getAlpha() {
        if (!ModularUI.Mods.NEA.isLoaded() || NEAConfig.openingAnimationTime == 0) {
            return 1.0f;
        }
        return this.getAnimator().getValue();
    }

    public final boolean isMainPanel() {
        return this.getScreen().getMainPanel() == this;
    }

    @Override
    @ApiStatus.Internal
    public void setSyncHandler(@Nullable SyncHandler syncHandler) {
        if (!this.isValidSyncHandler(syncHandler)) {
            throw new IllegalStateException("Panel SyncHandler's must implement IPanelHandler!");
        }
        super.setSyncHandler(syncHandler);
        this.setPanelHandler((IPanelHandler)((Object)syncHandler));
    }

    @NotNull
    protected Animator getAnimator() {
        if (this.animator == null) {
            this.animator = new Animator().bounds(0.0f, 1.0f).duration(NEAConfig.openingAnimationTime).curve(Interpolation.getForName(NEAConfig.openingAnimationCurve.getName()));
            this.animator.reset(true);
        }
        return this.animator;
    }

    @ApiStatus.Internal
    public boolean shouldAnimate() {
        return !this.getScreen().isOverlay() && ModularUI.Mods.NEA.isLoaded() && NEAConfig.openingAnimationTime > 0;
    }

    void registerSubPanel(IPanelHandler handler) {
        if (!this.clientSubPanels.contains(handler)) {
            this.clientSubPanels.add(handler);
        }
    }

    void closeClientSubPanels() {
        for (IPanelHandler handler : this.clientSubPanels) {
            if (!handler.isSubPanel()) continue;
            handler.closePanel();
        }
    }

    public ModularPanel bindPlayerInventory() {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory(true));
    }

    public ModularPanel bindPlayerInventory(int bottom) {
        return (ModularPanel)this.child(SlotGroupWidget.playerInventory(bottom, true));
    }

    public ModularPanel invisible() {
        this.invisible = true;
        return (ModularPanel)this.background(IDrawable.EMPTY);
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.getName();
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        IDLE,
        OPEN,
        CLOSED,
        DISPOSED,
        WAIT_DISPOSING;

    }

    private static class Input {
        private final ObjectList<Interactable> acceptedInteractions = ObjectList.create();
        @Nullable
        private LocatedWidget lastPressed;
        private boolean held;
        private long time;
        private int lastButton;
        private boolean doRelease = true;

        private Input() {
            this.reset();
        }

        private void addAcceptedInteractable(Interactable interactable) {
            if (!this.held) {
                this.acceptedInteractions.add(interactable);
            }
        }

        private void reset() {
            this.acceptedInteractions.clear();
            this.held = false;
            this.time = -1L;
            this.lastButton = -1;
            this.doRelease = true;
        }

        private boolean isValid() {
            return this.lastPressed != null && this.time > 0L;
        }

        private int getTimeSinceEvent() {
            return (int)Math.min(Minecraft.func_71386_F() - this.time, Integer.MAX_VALUE);
        }

        private boolean tryTap(int button) {
            return this.lastButton == button && this.getTimeSinceEvent() <= 200;
        }

        private boolean isWidget(IWidget widget) {
            return this.lastPressed != null && this.lastPressed.getElement() == widget;
        }

        private boolean isWidget(LocatedWidget widget) {
            return this.isWidget((IWidget)widget.getElement());
        }

        private void pressed(LocatedWidget pressed, int button) {
            if (!this.held) {
                this.lastPressed = pressed;
                if (this.lastPressed != null) {
                    this.time = Minecraft.func_71386_F();
                }
                this.lastButton = button;
                this.held = true;
            }
        }
    }
}

