/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.client;

import appeng.api.config.ViewItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.network.packet.client.ThEClientPacket;
import thaumicenergistics.common.registries.EnumCache;
import thaumicenergistics.common.storage.AspectStack;
import thaumicenergistics.common.storage.AspectStackComparator;

public class Packet_C_EssentiaCellTerminal
extends ThEClientPacket {
    private static final byte MODE_FULL_LIST = 0;
    private static final byte MODE_SELECTED_ASPECT = 1;
    private static final byte MODE_VIEWING_CHANGED = 2;
    private static final byte MODE_LIST_CHANGED = 3;
    private Collection<IAspectStack> aspectStackList;
    private Aspect selectedAspect;
    private AspectStackComparator.AspectStackComparatorMode sortMode;
    private IAspectStack change;
    private ViewItems viewMode;

    private static Packet_C_EssentiaCellTerminal newPacket(EntityPlayer player, byte mode) {
        Packet_C_EssentiaCellTerminal packet = new Packet_C_EssentiaCellTerminal();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendFullList(EntityPlayer player, Collection<IAspectStack> list) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)0);
        packet.useCompression = true;
        packet.aspectStackList = list;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendViewingModes(EntityPlayer player, AspectStackComparator.AspectStackComparatorMode sortMode, ViewItems viewMode) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)2);
        packet.sortMode = sortMode;
        packet.viewMode = viewMode;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void setAspectAmount(EntityPlayer player, IAspectStack change) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)3);
        packet.change = change;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void setSelectedAspect(EntityPlayer player, Aspect selectedAspect) {
        Packet_C_EssentiaCellTerminal packet = Packet_C_EssentiaCellTerminal.newPacket(player, (byte)1);
        packet.selectedAspect = selectedAspect;
        NetworkHandler.sendPacketToClient(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiEssentiaCellTerminal) {
            switch (this.mode) {
                case 0: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveAspectList(this.aspectStackList);
                    break;
                }
                case 1: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveSelectedAspect(this.selectedAspect);
                    break;
                }
                case 2: {
                    ((GuiEssentiaCellTerminal)gui).onViewingModesChanged(this.sortMode, this.viewMode);
                    break;
                }
                case 3: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveAspectListChange(this.change);
                }
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.aspectStackList = new ArrayList<IAspectStack>();
                while (stream.readableBytes() > 0) {
                    this.aspectStackList.add(AspectStack.loadAspectStackFromStream(stream));
                }
                break;
            }
            case 1: {
                this.selectedAspect = ThEBasePacket.readAspect(stream);
                break;
            }
            case 2: {
                this.sortMode = AspectStackComparator.AspectStackComparatorMode.VALUES[stream.readInt()];
                this.viewMode = EnumCache.AE_VIEW_ITEMS[stream.readInt()];
                break;
            }
            case 3: {
                this.change = AspectStack.loadAspectStackFromStream(stream);
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                for (IAspectStack stack : this.aspectStackList) {
                    stack.writeToStream(stream);
                }
                break;
            }
            case 1: {
                ThEBasePacket.writeAspect(this.selectedAspect, stream);
                break;
            }
            case 2: {
                stream.writeInt(this.sortMode.ordinal());
                stream.writeInt(this.viewMode.ordinal());
                break;
            }
            case 3: {
                this.change.writeToStream(stream);
            }
        }
    }
}

